package WSSSignature;

import com.ibm.wstk.axis.client.WSTKService;
import com.ibm.wstk.WSTKConstants;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Service;
import org.apache.axis.client.Call;

/*
* La classe Signer rcupre le jeton de scurit associ au certificat
* X509 choisi par l'utilisateur et s'en sert pour signer le message SOAP
* d'invocation du service Web de cotation d'actions WSE (.NET) ou WSTK
* (Java).
*/
public class Signer {

	String symbol;
	String implementation;

	/*
	* La classe reconnat 1 (minimum) ou 2 paramtre(s) :
	* 1. le symbole de la valeur boursire (obligatoire);
	* 2. le service de cotation  invoquer (facultatif : "WSE"
	* correspond au service .NET, "WSTK" correspond au service
	* Java et toute autre valeur correspond  une invocation 
	* des 2 services).
	*/
	public Signer(String[] args) {
		symbol = args[0];
		implementation = "ALL";
		if (args.length == 2) {
			implementation = args[1];
		}
	}
	
	/*
	* Point d'entre de l'application.
	*/
	public static void main(String[] args) {
		Signer signer = null;
		try {
			signer = new Signer(args);
			if (signer.implementation.equals("WSE")) {
				signer.signWSE();
				return;
			}
			if (signer.implementation.equals("WSTK")) {
				signer.signWSTK();
				return;
			}
			signer.signWSE();
			signer.signWSTK();
		}
		catch (Exception e) {
			System.out.println("\nL'un des paramtres est incorrect ou absent.");
			return;
		}
	}
        
	/*
	* Signature et invocation du service Web .NET.
	*/
	private void signWSE() {
		// Installation du client en fonction du descripteur correspondant.
		String deploymentDirectory = new String(WSTKConstants.WSTK_HOME+"/services/demos/wss-signature/deployment");
		String clientWSDDFile = deploymentDirectory+"/deploy_client_WSE.wsdd";
		try {
			WSTKService.processWSDDFile(clientWSDDFile);
		} 
		catch (Exception e) {
			System.out.println(e);
		}

		System.out.println("Signature et invocation du service Web .NET...");
		Float value = null; 

		try {
			// Cration d'une instance du service local.
			Service service = new Service();
			Call call = (Call) service.createCall();
			
			String accessPoint = "http://localhost:80/WSS-Signature/StockQuotationService.asmx";    
			call.setTargetEndpointAddress(new URL(accessPoint));

			call.addParameter(new QName("urn:WSS-Signature", "symbol"), new QName("http://www.w3.org/2001/XMLSchema", "string"), String.class, ParameterMode.IN);
			call.setReturnType(new QName("http://www.w3.org/2001/XMLSchema", "float"), float.class);
			call.setUseSOAPAction(true);
			call.setSOAPActionURI("urn:WSS-Signature/GetQuote");
			call.setOperationName(new QName("urn:WSS-Signature", "GetQuote"));
	
			// Invocation du service Web .NET.
			System.out.println("\nInvocation de : " + accessPoint);
			value = (Float)call.invoke( new Object[] {symbol});

			// Affichage du rsultat de l'invocation.
			System.out.println("Valeur de l'action " + symbol + " : " + value);
		} 
		catch (Exception e) {
			System.out.println(e);
		}

		// Dsinstallation du client en fonction du descripteur correspondant.
		deploymentDirectory = new String(WSTKConstants.WSTK_HOME+"/services/demos/wss-signature/deployment");
		clientWSDDFile = deploymentDirectory+"/undeploy_client_WSE.wsdd";
		try {
			WSTKService.processWSDDFile(clientWSDDFile);
		} 
		catch (Exception e) {
			System.out.println(e);
		}
	}

	/*
	* Signature et invocation du service Web Java.
	*/
	private void signWSTK() {
		// Installation du client et du serveur en fonction des descripteurs correspondants.
		String deploymentDirectory = new String(WSTKConstants.WSTK_HOME+"/services/demos/wss-signature/deployment");
		String clientWSDDFile = deploymentDirectory+"/deploy_client_WSTK.wsdd";
		try {
			WSTKService.processWSDDFile(clientWSDDFile);
		} 
		catch (Exception e) {
			System.out.println(e);
		}

		System.out.println("Signature et invocation du service Web Java...");
		Float value = null; 

		try {
			// Cration d'une instance du service local.
			Service service = new Service();
			Call call = (Call) service.createCall();
    
			String accessPoint = "http://localhost:8080/wstk/wss-signature/services/SignatureStockQuoteService";    
			call.setTargetEndpointAddress(new URL(accessPoint));

			call.addParameter(new QName("", "in0"), new QName("http://www.w3.org/2001/XMLSchema", "string"), String.class, ParameterMode.IN);
			call.setReturnType(new QName("http://www.w3.org/2001/XMLSchema", "float"), float.class);
			call.setUseSOAPAction(true);
			call.setSOAPActionURI("");
			call.setOperationName(new QName("http://localhost:8080/wstk/wss-signature/services/SignatureStockQuoteService", "getQuote"));
	
			// Invocation du service Web Java.
			System.out.println("\nInvocation de : " + accessPoint);
			value = (Float)call.invoke( new Object[] {symbol});

			// Affichage du rsultat de l'invocation.
			System.out.println("Valeur de l'action " + symbol + " : " + value);
		} 
		catch (Exception e) {
			System.out.println(e);
		}

		// Dsinstallation du client et du serveur en fonction des descripteurs correspondants.
		deploymentDirectory = new String(WSTKConstants.WSTK_HOME+"/services/demos/wss-signature/deployment");
		clientWSDDFile = deploymentDirectory+"/undeploy_client_WSTK.wsdd";
		try {
			WSTKService.processWSDDFile(clientWSDDFile);
		} 
		catch (Exception e) {
			System.out.println(e);
		}
	}
}
